<?php
add_action( 'add_meta_boxes', 'cd_meta_box_add' );
function cd_meta_box_add(){
	add_meta_box( 'cd_meta_box_slide_show', 'تنظیمات اسلاید شو', 'cd_meta_box_slide_show', 'slide_show', 'normal', 'high' );
	add_meta_box( 'cd_meta_box_notifecation', 'تنظیمات نظر کاربران', 'cd_meta_box_notifecation', 'my_comments', 'normal', 'high' );
}
function cd_meta_box_slide_show( $post ) {
	$values = get_post_custom( $post->ID );
	$text_slide_show_img = isset( $values['slide_show_img'] ) ? esc_attr( $values['slide_show_img'][0] ) : '';
	$check_slide_show_check = isset( $values['slide_show_check'] ) ? esc_attr( $values['slide_show_check'][0] ) : '';
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
	<p>
		<label for="slide_show_check">آیا مایل به نمایش اطلاعات در صفحه اصلی هستید ؟</label>
		<select name="slide_show_check" id="slide_show_check">
			<option value="off" <?php selected( $check_slide_show_check, 'off' ); ?>>خیر</option>
			<option value="on" <?php selected( $check_slide_show_check, 'on' ); ?>>بله</option>
		</select>
	</p>
	<hr />
	<p>
		<p>تصویر اسلاید شو</p>
		<input type="text" name="slide_show_img" id="slide_show_img" value="<?php echo $text_slide_show_img; ?>" style="width:100%;direction:ltr;" />
		<p>تصویر باید در ابعاد 1140 در 400 پیکسل باشد</p>
	</p>
<?php }
function cd_meta_box_notifecation( $post ) {
	$values = get_post_custom( $post->ID );
	$text_user_comment = isset( $values['user_comment'] ) ? esc_attr( $values['user_comment'][0] ) : '';
	$check_my_comments_check = isset( $values['my_comments_check'] ) ? esc_attr( $values['my_comments_check'][0] ) : '';
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
	<p>
		<label for="my_comments_check">آیا مایل به نمایش اطلاعات در صفحه اصلی هستید ؟</label>
		<select name="my_comments_check" id="my_comments_check">
			<option value="off" <?php selected( $check_my_comments_check, 'off' ); ?>>خیر</option>
			<option value="on" <?php selected( $check_my_comments_check, 'on' ); ?>>بله</option>
		</select>
	</p>
	<hr />
	<p>
		<p>نام کاربر</p>
		<input type="text" name="user_comment" id="user_comment" value="<?php echo $text_user_comment; ?>" style="width:100%" />
		<p>نام کاربری که نظر را ارسال نموده وارد کنید</p>
	</p>
<?php }
add_action( 'save_post', 'cd_meta_box_save' );
function cd_meta_box_save( $post_id ) {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post' ) ) return;
	$allowed = array( 
		'a' => array( 
			'href' => array()
		)
	);
	if( isset( $_POST['slide_show_img'] ) )
		update_post_meta( $post_id, 'slide_show_img', wp_kses( $_POST['slide_show_img'], $allowed ) );
	
	if( isset( $_POST['slide_show_check'] ) )
		update_post_meta( $post_id, 'slide_show_check', esc_attr( $_POST['slide_show_check'] ) );
	
	if( isset( $_POST['user_comment'] ) )
		update_post_meta( $post_id, 'user_comment', wp_kses( $_POST['user_comment'], $allowed ) );
	
	if( isset( $_POST['my_comments_check'] ) )
		update_post_meta( $post_id, 'my_comments_check', esc_attr( $_POST['my_comments_check'] ) );
	
} ?>